//*******************************************************************
//
//  Sample Program for LCD Contrast
//
//  Target Machine : CPT-711
//
//  Function:
//  void IncContrast(void)      : Increase the LCD contrast
//  void DecContrast(void)      : Decrease the LCD contrast
//  void SetContrast(int level) : To set contrast level for the LCD
//                                The level is ranging from 0 to 7
//
//  SYNTECH INFORMATION CO., LTD.
//
//*******************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lib\711lib.h"

void main (void)
    {
    unsigned char  ckey;

    clr_scr ();
    gotoxy (2,1);
    puts ("LCD CONTRAST TEST");

    gotoxy (2,4);
    puts ("KEY UP:DECREASE");
    gotoxy (2,5);
    puts ("KEY DN:INCREASE");

    SetContrast (4);
    while (1)
         {
         if (ckey = getchar())
             {
             switch (ckey)
                 {
                 case KEY_UP:
                      DecContrast();
                      break;

                 case KEY_DOWN:
                      IncContrast();
                      break;
                 }
             }
         }
    }

//-------------------------------------------------------------------------//
